
var doOverlay = true;


function openLinkToBlastWithSequence(row_id) {

	var mapForm = document.createElement("form");
    mapForm.target = '_blank';
    mapForm.method = 'POST';
    mapForm.action = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';
	mapForm.style = 'display:none;';


	attachInput(mapForm, 'CMD', 'request');
	attachInput(mapForm, 'db', 'nucleotide');
	attachInput(mapForm, 'DATABASE', 'nr');
	attachInput(mapForm, 'PROGRAM', 'blastn');

	attachInput(mapForm, 'QUERY', OTU_table_seq[row_id]);
	attachInput(mapForm, 'EXCLUDE_SEQ_UNCULT', 'on');

	/*
	attachInput(mapForm, 'GENETIC_CODE', 1);
	attachInput(mapForm, 'stype', 'nucleotide');
	attachInput(mapForm, 'DBTYPE', 'gc');
	attachInput(mapForm, 'NUM_ORG', 1);
	*/


	//attach to document
    document.body.appendChild(mapForm);
	mapForm.submit();

	//remove from document again (dont need it any more
	document.body.removeChild(mapForm);

	focus();

	return false;
}


function attachInput(mapForm, name, value) {
    var mapInput = document.createElement("input");
    mapInput.type = 'text';
    mapInput.name = name;
    mapInput.value = value;
    mapForm.appendChild(mapInput);

}


function create_mouseover(OTU_table,row_id,col_id,row_sum,col_sum,lineage,taxonomy){

	//do nothing if not enabled
	if(!doOverlay) return function() {};

    /*This creates the mouseover functionality of the cells*/
    var table_row_len=OTU_table[row_id].length-1;
    if (taxonomy==1){
        var split_lineage=OTU_table[row_id][lineage].split(";");
        var OTU_label=OTU_table[row_id][table_row_len];
        var Sample_label=OTU_table[0][col_id];
    }else{
	    var split_lineage=OTU_table[lineage][col_id].split(";");
	    var OTU_label=OTU_table[0][col_id];
	    var Sample_label=OTU_table[row_id][0];
    }

	var otu_seq_text = '';
	if(typeof(OTU_table_seq[OTU_label]) !== 'undefined') {
		otu_seq_text += "<br /><br /><b>OTU Seq:</b>";

		otu_seq_text += " <button type='button' onclick='openLinkToBlastWithSequence(\\\""+OTU_label+"\\\");'>blast</button><br />";


		otu_seq_text += OTU_table_seq[OTU_label];
	}


	mouseover_str="return overlib(\"";
	mouseover_str+="<p><b>OTU: ";
	mouseover_str+=OTU_label;
	mouseover_str+="</b><br>";
	mouseover_str+=OTU_table[row_id][col_id]
	mouseover_str+="/";
	mouseover_str+=col_sum;
	mouseover_str+=" (";
	mouseover_str+=(OTU_table[row_id][col_id]/col_sum*100).toFixed(2);
	mouseover_str+="%) Sequences";

	mouseover_str+=otu_seq_text;

	mouseover_str+="<br><br><b>SampleID: ";
	mouseover_str+=Sample_label;
	mouseover_str+="</b><br>";
	mouseover_str+=OTU_table[row_id][col_id];
	mouseover_str+="/";
	mouseover_str+=row_sum;
	mouseover_str+=" (";
	mouseover_str+=(OTU_table[row_id][col_id]/row_sum*100).toFixed(2);
	mouseover_str+="%) Displayed";

	mouseover_str+="<br><br><b>Lineage: ";
    for (var i=0;i<split_lineage.length-2;i++){
		mouseover_str+="<br>"+split_lineage[i];
	}
	var query_string=split_lineage[i].split(' ').join('');
	small_link='http://www.google.com/search?q='+query_string+'';

	open_window="javascript:window.open("+small_link+",'win2');";
	mouseover_str+="<br><a href="+"'"+small_link+"' target='_blank'"+">";
	mouseover_str+=split_lineage[i];
	mouseover_str+="</a>";

	mouseover_str+="</b></p>";
	mouseover_str+="\",STICKY,MOUSEOFF,RIGHT);"

	return mouseover_str;
}


